	function[deltaZ, dopt] = lp_find_new_poles(Z, NIN, Amax, Zmin, Dmin)
 	%
	% Finds the change in the location of the attenuation poles and  
	% the minimum attenuation dopt.
	% Inputs are the attenuation pole vector Z, the number of attenuation 
	% poles at infinity NIN, the passband attenuation Amax, the z frequencies 
	% Zmin in which the minimum difference to the specification occurs and 
	% the minimum difference vector D_min.
	
	% Author: 			Per Loewenborg
    % Modified by:		LW
	% Copyright:		by authors - not released for commercial use
	% Version: 			1	
	% Known bugs:		None
	% Report bugs to:	larsw@isy.liu.se
 	
	ep_sqred = (10^(0.1*Amax)) - 1;
	N = length(Z);
	K = 40/log(10);
	for r = 1:length(Dmin)
		for k = 1:N
			Labs = abs(lp_loss_epb(Z, NIN, Zmin(r)));
			A(r,k) = ( K*(Labs^2-1/(Labs^2))/(4/ep_sqred + (Labs+1/Labs)^2))...
			*Zmin(r)*(1/(Zmin(r)^2-Z(k)^2));    
		end  
	end
	for r = 1:length(Dmin)
		A(r,N+1) = -1;
	end
	X = inv(A)*(-Dmin');
	deltaZ = X(1:length(X)-1)';
	dopt = X(length(X));
